unit CarClass;

interface

uses sysUtils;

type
  TCar = class
  private
    brand: string;
    model: string;
    year: string;
    retailPrice: double;
  public
    constructor create; overload;
    constructor create(brand, model, year: string; retailPrice: double);
      overload;
    function getDetailedModel: string;
    procedure setRetailPrice(retailPrice: double);
    function getRetailPrice: double;
    function toString: string;
    function getVATPrice:double;
  end;

implementation

{ TCar }

constructor TCar.create;
begin

end;

constructor TCar.create(brand, model, year: string; retailPrice: double);
begin
    Self.brand:= brand;
    Self.model:= model;
    Self.year:= year;
    Self.retailPrice:= retailPrice;
end;

function TCar.getDetailedModel: string;
begin
  Result:= year + ' ' + brand + ' ' + model;
end;

function TCar.getRetailPrice: double;
begin
  Result:= retailPrice;
end;

function TCar.getVATPrice: double;
begin
  Result := retailPrice * 1.15;
end;

procedure TCar.setRetailPrice(retailPrice: double);
begin
  Self.retailPrice:= retailPrice;
end;

function TCar.toString: string;
begin
    Result := 'Brand: ' + brand + sLineBreak +
    'Model: ' + model + sLineBreak +
    'Year: ' + year + sLineBreak +
    'Retail price: ' + floatToStr(retailPrice);
end;

end.
